#include <stdlib.h>
#include <stdio.h>
#include <strings.h>
#include <gtk/gtk.h>

#include "aube_samplelist.h"
#include "sample_if.h"
#include "aube.h"
#include "master.h"
#include "modulemenu.h"
#include "opsmenu.h"
#include "saube.h"
#include "slider.h"
#include "inputoption.h"

extern int tick;

extern GtkWidget *master_daddy;
extern aube_data *aube_daddy;
GtkWidget *samplelist_daddy;


guint aube_samplelist_get_type(void);
static void aube_samplelist_class_init(AubeSamplelistClass * class);
static void aube_samplelist_init(AubeSamplelist * b);
GtkWidget *aube_samplelist_new();
void aube_samplelist_dismiss(GtkWidget * widget, gpointer data);
void aube_samplelist_refresh_samplelist(GtkWidget * widget, gpointer * data);
static gint aube_samplelist_events(GtkWidget * widget, GdkEventButton * bevent, gpointer data);
/*
   void aube_samplelist_save_sample(GtkWidget *widget, gpointer data);
 */
void aube_samplelist_edit_sample(GtkWidget * widget, gpointer data);
void aube_samplelist_delete_sample(GtkWidget * widget, gpointer data);

channel *selected_sample;

guint
aube_samplelist_get_type()
{
  static guint b_type = 0;

  if (!b_type) {
    GtkTypeInfo b_info =
    {
      "AubeSamplelist",
      sizeof(AubeSamplelist),
      sizeof(AubeSamplelistClass),
      (GtkClassInitFunc) aube_samplelist_class_init,
      (GtkObjectInitFunc) aube_samplelist_init,
      (GtkArgSetFunc) NULL,
      (GtkArgGetFunc) NULL,
    };

    b_type = gtk_type_unique(gtk_window_get_type(), &b_info);
  }
  return b_type;
}

enum {
  LAST_SIGNAL
};

static gint aube_samplelist_signals[LAST_SIGNAL] =
{0};

static void
aube_samplelist_class_init(AubeSamplelistClass * class)
{
  GtkObjectClass *object_class;

  object_class = (GtkObjectClass *) class;

  gtk_object_class_add_signals(object_class, aube_samplelist_signals, LAST_SIGNAL);
  class->aube_samplelist = NULL;
}

static void
aube_samplelist_init(AubeSamplelist * aube_samplelist)
{
}

GtkWidget *
aube_samplelist_new()
{
  AubeSamplelist *aube_samplelist = NULL;
  GtkWidget *menubar, *menu, *menuitem;
  GtkWidget *vbox2;
  gchar *titles[] =
  {"", "Name", "Length"};

  aube_samplelist = gtk_type_new(aube_samplelist_get_type());

/*
   aube_samplelist->data = s;
 */

  gtk_window_set_title(GTK_WINDOW(aube_samplelist), "AUBE Sample List");

  gtk_container_border_width(GTK_CONTAINER(aube_samplelist), 1);

#if 0

  /*
     when the window is given the "delete_event" signal - this is
     * given by the window manager - usually the close option or on the
     * titlebar - we ask it to call the delete_event() function
     * as defined above. The data passed to the callback function is
     * NULL and is ignored in the callback. 
   */
  gtk_signal_connect(GTK_OBJECT(aube_samplelist), "delete_event",
		     GTK_SIGNAL_FUNC(delete_event), NULL);

  /*
     here we connect the "destroy" event to a signal hanser.
     * This event occurs when we call gtk_widget_destroy() on the
     * window, or if we return "TRUE" in the "delete_event" callback. 
   */
  gtk_signal_connect(GTK_OBJECT(aube_samplelist), "destroy",
		     GTK_SIGNAL_FUNC(destroy), NULL);
#endif

  vbox2 = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(aube_samplelist), vbox2);


  /*
     M E N U B A R 
   */

  menubar = gtk_menu_bar_new();
  gtk_box_pack_start(GTK_BOX(vbox2), menubar, FALSE, TRUE, 0);

  /*
     FILE MENU 
   */

  menu = gtk_menu_new();

  menuitem = gtk_menu_item_new_with_label("Load Sample...");
  gtk_menu_append(GTK_MENU(menu), menuitem);
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
		     GTK_SIGNAL_FUNC(sample_load_cb), NULL);
  gtk_widget_show(menuitem);

  menuitem = gtk_menu_item_new_with_label("Save Sample...");
  gtk_menu_append(GTK_MENU(menu), menuitem);
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
		     GTK_SIGNAL_FUNC(sample_save_cb), NULL);
/*
   gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
   GTK_SIGNAL_FUNC(aube_samplelist_save_sample), aube_samplelist);
 */
  gtk_widget_show(menuitem);

  menuitem = gtk_menu_item_new_with_label("Close");
  gtk_menu_append(GTK_MENU(menu), menuitem);
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
		 GTK_SIGNAL_FUNC(aube_samplelist_dismiss), aube_samplelist);
  gtk_widget_show(menuitem);

  menuitem = gtk_menu_item_new_with_label("File");
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuitem), menu);
  gtk_menu_bar_append(GTK_MENU_BAR(menubar), menuitem);
  gtk_widget_show(menuitem);

  gtk_widget_show(menubar);

#if 0
  hbox = gtk_hbox_new(FALSE, 1);
  gtk_box_pack_start(GTK_BOX(vbox2), hbox, FALSE, FALSE, 1);
  gtk_widget_show(hbox);

  widget = gtk_toggle_button_new_with_label("On");
  gtk_box_pack_start(GTK_BOX(hbox), widget, FALSE, FALSE, 1);
  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(widget), aube_samplelist->data->module.on);
  gtk_signal_connect(GTK_OBJECT(widget), "clicked",
	  GTK_SIGNAL_FUNC(aube_samplelist_onoff_cb), aube_samplelist->data);
  gtk_widget_show(widget);
#endif

  aube_samplelist->sl = gtk_clist_new_with_titles(3, titles);
  gtk_clist_column_titles_passive(GTK_CLIST(aube_samplelist->sl));
  gtk_clist_set_selection_mode(GTK_CLIST(aube_samplelist->sl), GTK_SELECTION_BROWSE);
  /*
     gtk_clist_set_policy(GTK_CLIST(aube_samplelist->sl), GTK_POLICY_AUTOMATIC,
     GTK_POLICY_AUTOMATIC);
   */
  /*
     gtk_clist_set_border(GTK_CLIST(aube_samplelist->sl), GTK_SHADOW_IN);
   */
  gtk_clist_set_column_width(GTK_CLIST(aube_samplelist->sl), 0, 12);
  gtk_clist_set_column_width(GTK_CLIST(aube_samplelist->sl), 1, 80);
  gtk_clist_set_column_width(GTK_CLIST(aube_samplelist->sl), 2, 30);
  gtk_clist_set_column_justification(GTK_CLIST(aube_samplelist->sl), 2,
				     GTK_JUSTIFY_RIGHT);

  gtk_box_pack_start(GTK_BOX(vbox2), aube_samplelist->sl, TRUE, TRUE, 1);

  aube_samplelist_refresh_samplelist(NULL, (gpointer *) aube_samplelist);
  gtk_widget_show(aube_samplelist->sl);

  aube_samplelist->handler_id = gtk_signal_connect(GTK_OBJECT(master_daddy),
     "modules_changed", GTK_SIGNAL_FUNC(aube_samplelist_refresh_samplelist),
						   aube_samplelist);

  gtk_signal_connect(GTK_OBJECT(aube_samplelist->sl), "button_press_event",
		  GTK_SIGNAL_FUNC(aube_samplelist_events), aube_samplelist);

  gtk_widget_show(vbox2);

  aube_samplelist->commands_menu = gtk_menu_new();

  gtk_widget_set_usize(GTK_WIDGET(aube_samplelist), 160, 240);

#if 0
  menuitem = gtk_menu_item_new_with_label("Edit...");
  gtk_menu_append(GTK_MENU(aube_samplelist->commands_menu), menuitem);
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
		     GTK_SIGNAL_FUNC(aube_samplelist_edit_sample), NULL);
  gtk_widget_show(menuitem);
#endif

  menuitem = gtk_menu_item_new_with_label("Save...");
  gtk_menu_append(GTK_MENU(aube_samplelist->commands_menu), menuitem);
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
		     GTK_SIGNAL_FUNC(sample_save_cb), NULL);
  gtk_widget_show(menuitem);

  menuitem = gtk_menu_item_new_with_label("Close");
  gtk_menu_append(GTK_MENU(aube_samplelist->commands_menu), menuitem);
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
	   GTK_SIGNAL_FUNC(aube_samplelist_delete_sample), aube_samplelist);
  gtk_widget_show(menuitem);

  return GTK_WIDGET(aube_samplelist);
}

void
aube_samplelist_refresh_samplelist(GtkWidget * widget, gpointer * data)
{
  int i;
  gchar *title[3];
  gchar buf1[16];
  gchar buf2[16];
  AubeSamplelist *aube_samplelist;

  aube_samplelist = AUBE_SAMPLELIST(data);
  gtk_clist_freeze(GTK_CLIST(aube_samplelist->sl));
  gtk_clist_clear(GTK_CLIST(aube_samplelist->sl));
  title[0] = buf1;
  title[2] = buf2;
  for (i = 0; i < aube_daddy->nr_samples; i++) {
    sprintf(title[0], "%02d", i);
    title[1] = aube_daddy->samples[i]->u_label;
    sprintf(title[2], "%d",
	    aube_daddy->samples[i]->parms.d.audio_sample_data.s_length);
    gtk_clist_append(GTK_CLIST(aube_samplelist->sl), (gchar **) & title);
  }
  gtk_clist_thaw(GTK_CLIST(aube_samplelist->sl));
}

void
aube_samplelist_dismiss(GtkWidget * widget, gpointer data)
{
  gtk_signal_disconnect(GTK_OBJECT(master_daddy), AUBE_SAMPLELIST(data)->handler_id);
  gtk_widget_destroy(GTK_WIDGET(data));
  samplelist_daddy = NULL;
}

static gint
aube_samplelist_events(GtkWidget * widget, GdkEventButton * bevent, gpointer data)
{
  GtkWidget *clist;
  AubeSamplelist *aube_samplelist;
  gint row, col;

  /*
     clist = GTK_CLIST(widget);
   */
  aube_samplelist = AUBE_SAMPLELIST(data);
  clist = GTK_WIDGET(aube_samplelist->sl);

  if (bevent->button == 3) {
    gtk_clist_get_selection_info(GTK_CLIST(clist), bevent->x, bevent->y, &row, &col);
    selected_sample = aube_daddy->samples[row];
    gtk_menu_popup(GTK_MENU(aube_samplelist->commands_menu), NULL, NULL, NULL,
		   aube_daddy->samples[row], 3, bevent->time);
  }
  return 1;
}

#if 0
void
aube_samplelist_save_sample(GtkWidget * widget, gpointer data)
{
  aube_save_sample(selected_sample);
}

#endif

void
aube_samplelist_edit_sample(GtkWidget * widget, gpointer data)
{
  GtkWidget *saube;

  saube = saube_new(selected_sample);
  gtk_widget_show(saube);
}

void
aube_samplelist_delete_sample(GtkWidget * widget, gpointer data)
{
  aube_remove_sample(selected_sample);
}
