#include <config.h>

#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <glib.h>

#if 0
#include <parser.h>
#include <tree.h>
#include <debugXML.h>
#endif

#include "aube.h"
#include "master.h"

typedef struct _label_remapping label_remapping;

struct _label_remapping {
  char *label;
  module *module;
  int on;
  int has_if;
};

static module * get_remapped_module(char *old_label);

label_remapping remappings[MAX_UNITS];
int nr_remappings=0;

#if 0
static void
aubemlSetProp_int(xmlNodePtr tree, gchar * name, gint val)
{
  gchar buf[16];

  snprintf(buf, 16, "%d", val);
  xmlSetProp(tree, name, buf);
}

static void
aubemlSetProp_module(xmlNodePtr tree, gchar * name, module * m)
{
  xmlSetProp(tree, name, m->u_label);
}


#if 0
xmlNodePtr
aubeml_write_type(xmlNodePtr parent, aube_type * t)
{
  xmlNodePtr tree;

  tree = xmlNewChild(parent, NULL, "type", NULL);
  aubemlSetProp_int(tree, "no", t->type);
  aubemlSetProp_int(tree, "instances", t->instances);
  xmlSetProp(tree, "label", (char *) t->type_label);

  return tree;
}
#endif


static xmlNodePtr
aubeml_write_ch_parameters(xmlNodePtr parent, ch_parameters * cp)
{
  xmlNodePtr tree;

  tree = xmlNewChild(parent, NULL, "ch_parms", NULL);
  aubemlSetProp_int(tree, "type", cp->ch_type);

  switch (cp->ch_type) {
  case CH_TYPE_SEQUENCE:
    aubemlSetProp_int(tree, "seq_data", cp->d.sequence_data);
    break;
  case CH_TYPE_AUDIO_STREAM:
    aubemlSetProp_int(tree, "nr_channels", cp->d.audio_stream_data.nr_channels);
    aubemlSetProp_int(tree, "bitrate", cp->d.audio_stream_data.bitrate);
    aubemlSetProp_int(tree, "frequency", cp->d.audio_stream_data.frequency);
    break;
  case CH_TYPE_AUDIO_SAMPLE:
    aubemlSetProp_int(tree, "s_length", cp->d.audio_sample_data.s_length);
    break;
  }

  return tree;
}

static xmlNodePtr
aubeml_write_channel(xmlNodePtr parent, channel * ch, int index, int write_parms)
{
  xmlNodePtr tree;

  tree = xmlNewChild(parent, NULL, "channel", NULL);

  if (!ch) {
    xmlSetProp(tree, "label", "None");
  } else {
    if(write_parms)
      aubeml_write_ch_parameters(tree, &ch->parms);

    aubemlSetProp_module(tree, "module", ch->module);
    aubemlSetProp_int(tree, "index", index);
    xmlSetProp(tree, "label", ch->u_label);
  }

  return tree;
}

static xmlNodePtr
aubeml_write_module(xmlNodePtr parent, module * m)
{
  xmlNodePtr tree, subtree;
  gint i;

  tree = xmlNewChild(parent, NULL, "module", NULL);

  xmlSetProp(tree, "class", m->class->type_label);
  aubemlSetProp_int(tree, "on", m->on);
  aubemlSetProp_int(tree, "has_if", (m->has_if == 0) ? 0 : 1);
  xmlSetProp(tree, "label", m->u_label);

  subtree = xmlNewChild(tree, NULL, "inputs", NULL);
  aubemlSetProp_int(subtree, "nr_inputs", m->nr_inputs);
  for (i = 0; i < m->nr_inputs; i++) {
    aubeml_write_channel(subtree, m->inputs[i]->channel, i, FALSE);
  }

  subtree = xmlNewChild(tree, NULL, "outputs", NULL);
  aubemlSetProp_int(subtree, "nr_outputs", m->nr_outputs);
  for (i = 0; i < m->nr_outputs; i++) {
    aubeml_write_channel(subtree, m->outputs[i], i, TRUE);
  }

  return tree;
}

static xmlNodePtr
aubeml_write_aube_daddy(xmlNodePtr parent, aube_data * a)
{
  xmlNodePtr tree, subtree, subsubtree;
  gint i;

  tree = xmlNewChild(parent, NULL, "aube_data", NULL);

  aubemlSetProp_int(tree, "nr_channels", a->nr_channels);

#if 0
  subtree = xmlNewChild(tree, NULL, "types", NULL);
  aubemlSetProp_int(subtree, "nr_types", a->nr_types);
  for (i = 0; i < a->nr_types; i++) {
    aubeml_write_type(subtree, &a->types[i]);
  }
#endif

  subtree = xmlNewChild(tree, NULL, "modules", NULL);
  aubemlSetProp_int(subtree, "nr_modules", a->nr_modules);
  for (i = 0; i < a->nr_modules; i++) {
    if(strcmp(a->modules[i]->class->type_label, "none"))
      subsubtree = aubeml_write_module(subtree, a->modules[i]);
  }

  subtree = xmlNewChild(tree, NULL, "samples", NULL);
  aubemlSetProp_int(subtree, "nr_samples", a->nr_samples);

  return tree;
}
#endif

int
write_workspace(aube_data * a, char *filename)
{
#if 0
  xmlDocPtr doc;
  xmlNodePtr tree;
  char *filebase;
  char *tmpdir;

  filebase = rindex(filename, '/');
  fprintf(stderr, "filename: %s\tfilebase: %s\n", filename, filebase);
  tmpdir = tmpnam(NULL);
  fprintf(stderr, "tmpdir: %s\n", tmpdir);
  

  doc = xmlNewDoc("1.0");
  doc->root = xmlNewDocNode(doc, NULL, "Workspace", NULL);

  tree = aubeml_write_aube_daddy(doc->root, a);

#ifdef DEBUG
  xmlDocDump(stdout, doc);
#endif

  xmlSaveFile(filename, doc);

  xmlFreeDoc(doc);

#endif
  return 0;
}

#if 0
static void
read_module(xmlNodePtr tree)
{
  xmlAttrPtr attr;
  module_class *mc;
  int on=0, has_if=0;
  char * label;
  module *m;

  for (attr = tree->properties; attr; attr = attr->next) {
    if (!xmlStrcmp(attr->name, "class")) {
      mc = aube_get_module_class(attr->val->content);
    } else if(!xmlStrcmp(attr->name, "on")) {
      on = atoi(attr->val->content);
    } else if(!xmlStrcmp(attr->name, "has_if")) {
      has_if = atoi(attr->val->content);
    } else if(!xmlStrcmp(attr->name, "label")) {
      label = attr->val->content;
    }
  }
  if(mc) {
    m = aube_module_new_instance(mc);
    remappings[nr_remappings].label = label;
    remappings[nr_remappings].module = m;
    remappings[nr_remappings].on = on;
    remappings[nr_remappings].has_if = has_if;
    nr_remappings++;
  }
}

static void
connect_inputs(module *m, xmlNodePtr tree)
{
  xmlNodePtr subtree;
  xmlAttrPtr attr;
  int index=0;
  module *outm=NULL;
  char *label=NULL;
  int i;

  if(!m) return;

  for(subtree = tree->childs; subtree; subtree = subtree->next) {
    for(attr = subtree->properties; attr; attr = attr->next) {
      if(!xmlStrcmp(attr->name, "module")) {
        outm = get_remapped_module(attr->val->content);
      } else if(!xmlStrcmp(attr->name, "label")) {
        label = attr->val->content;
      } else if(!xmlStrcmp(attr->name, "index")) {
        index = atoi(attr->val->content);
      }
    }
    if(outm) {
      for(i=0; i<MAX_CHANNELS; i++) {
        if(!strcmp(label, outm->outputs[i]->u_label)) {
          m->inputs[index]->channel = outm->outputs[i];
          break;
        }
      }
    }
  }
}

static module *
get_remapped_module(char *old_label)
{
  int i;

  for(i=0; i<nr_remappings; i++) {
    if(!strcmp(old_label, remappings[i].label)) {
      return remappings[i].module;
    }
  }
  return NULL;
}

static void
connect_module(xmlNodePtr tree)
{
  xmlNodePtr subtree, subsubtree;
  xmlAttrPtr attr;
  module_class *mc;
  module *m;

  for (attr = tree->properties; attr; attr = attr->next) {
    if(!xmlStrcmp(attr->name, "label")) {
      m = get_remapped_module(attr->val->content);
    }
  }

  for (subtree = tree->childs; subtree; subtree = subtree->next) {
    if (!xmlStrcmp(subtree->name, "inputs")) {
      connect_inputs(m, subtree);
    }
  }

}

static void
read_modules(aube_data * a, xmlNodePtr tree)
{
  xmlNodePtr subtree;
  xmlAttrPtr attr;
  int i;

  nr_remappings = 0;

  for (attr = tree->properties; attr; attr = attr->next) {
  }
  for (subtree = tree->childs; subtree; subtree = subtree->next) {
    read_module(subtree);
  }
  for (subtree = tree->childs; subtree; subtree = subtree->next) {
    connect_module(subtree);
  }
  master_ack_channels_modified();


  /* Now that they are connected, turn them on ... */
  for(i=0; i<nr_remappings; i++) {
    aube_module_set_on(remappings[i].module, remappings[i].on);
  }

  /* And create their frontends ... */
  for(i=0; i<nr_remappings; i++) {
    if(remappings[i].has_if) aube_module_add_if(remappings[i].module);
  }

}

static void
read_samples(aube_data * a, xmlNodePtr tree)
{
#ifdef DEBUG
  g_print("Reading samples %s ...\n", tree->name);
#endif
}


static aube_data *
read_aube_data(xmlNodePtr tree)
{
  aube_data *a;
  xmlNodePtr subtree;
  xmlAttrPtr attr;

  a = aube_data_new();

  for (attr = tree->properties; attr; attr = attr->next) {

    if (!xmlStrcmp(attr->name, "nr_channels")) {
      a->nr_channels = atoi(attr->val->content);
    }
  }

  for (subtree = tree->childs; subtree; subtree = subtree->next) {
    if (!xmlStrcmp(subtree->name, "modules")) {
      read_modules(a, subtree);
    } else if (!xmlStrcmp(subtree->name, "samples")) {
      read_samples(a, subtree);
    }
  }

  return a;
}
#endif

aube_data *
read_workspace(char *filename)
{
#if 0
  xmlDocPtr doc;
  xmlNodePtr tree;
  aube_data *a;

  doc = xmlParseFile(filename);

  for (tree = doc->root->childs; tree; tree = tree->next) {
    if (!xmlStrcmp(tree->name, "aube_data")) {
      a = read_aube_data(tree);
    }
  }

  return a;
#endif
  return NULL;
}
