#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <gtk/gtk.h>

#include "aube.h"
#include "master.h"
#include "aubeml.h"

extern aube_data *aube_daddy;

static char last_aubeml_dir[256];

void
aubeml_load_ok_cb(GtkWidget * widget, gpointer data)
{
  gchar *dir;

  dir = gtk_file_selection_get_filename(GTK_FILE_SELECTION(data));
  strncpy(last_aubeml_dir, dir, MIN(256, strlen(dir)));
  read_workspace(dir);

  /* remove filename from dir */
  *(rindex(last_aubeml_dir, '/')) = '\0';

  gtk_widget_destroy(GTK_WIDGET(data));
}

void
aubeml_load_cancel_cb(GtkWidget * widget, gpointer data)
{
  gtk_widget_destroy(GTK_WIDGET(data));
}

void
aubeml_load_help_cb(GtkWidget * widget, gpointer data)
{
}


void
aubeml_load_cb(GtkWidget * wiget, gpointer data)
{
  GtkWidget *filesel;

  chdir(last_aubeml_dir);

  filesel = gtk_file_selection_new("Open Workspace");
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filesel)->ok_button),
		     "clicked", GTK_SIGNAL_FUNC(aubeml_load_ok_cb), filesel);
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filesel)->cancel_button),
		"clicked", GTK_SIGNAL_FUNC(aubeml_load_cancel_cb), filesel);
#if 0
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filesel)->help_button),
		  "clicked", GTK_SIGNAL_FUNC(aubeml_load_help_cb), filesel);
#endif

  gtk_widget_show(filesel);
}

void
aubeml_save_ok_cb(GtkWidget * widget, gpointer data)
{
  gchar *dir;

  dir = gtk_file_selection_get_filename(GTK_FILE_SELECTION(data));
  strncpy(last_aubeml_dir, dir, MIN(256, strlen(dir)));
  write_workspace(aube_daddy, dir);

  /* remove filename from dir */
  *(rindex(last_aubeml_dir, '/')) = '\0';

  gtk_widget_destroy(GTK_WIDGET(data));
}

void
aubeml_save_cancel_cb(GtkWidget * widget, gpointer data)
{
  gtk_widget_destroy(GTK_WIDGET(data));
}

void
aubeml_save_help_cb(GtkWidget * widget, gpointer data)
{
}

void
aubeml_save_cb(GtkWidget * wiget, gpointer data)
{
  GtkWidget *filesel;

  chdir(last_aubeml_dir);

  filesel = gtk_file_selection_new("Save Workspace");
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filesel)->ok_button),
		     "clicked", GTK_SIGNAL_FUNC(aubeml_save_ok_cb), filesel);
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filesel)->cancel_button),
		"clicked", GTK_SIGNAL_FUNC(aubeml_save_cancel_cb), filesel);
#if 0
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filesel)->help_button),
		  "clicked", GTK_SIGNAL_FUNC(aubeml_save_help_cb), filesel);
#endif

  gtk_widget_show(filesel);
}
