#include <strings.h>
#include <gtk/gtk.h>

#include "saube.h"
#include "sample_if.h"
#include "aube.h"
#include "master.h"
#include "modulemenu.h"
#include "opsmenu.h"
#include "slider.h"
#include "inputoption.h"

extern int tick;

extern GtkWidget *master_daddy;
extern aube_data *aube_daddy;
GtkWidget *samplelist_daddy;


guint saube_get_type(void);
static void saube_class_init(SaubeClass * class);
static void saube_init(Saube * b);
GtkWidget *saube_new();
void saube_refresh(Saube * s);
void saube_dismiss(GtkWidget * widget, gpointer data);

guint
saube_get_type()
{
  static guint b_type = 0;

  if (!b_type) {
    GtkTypeInfo b_info =
    {
      "Saube",
      sizeof(Saube),
      sizeof(SaubeClass),
      (GtkClassInitFunc) saube_class_init,
      (GtkObjectInitFunc) saube_init,
      (GtkArgSetFunc) NULL,
      (GtkArgGetFunc) NULL,
    };

    b_type = gtk_type_unique(gtk_window_get_type(), &b_info);
  }
  return b_type;
}

enum {
  LAST_SIGNAL
};

static gint saube_signals[LAST_SIGNAL] =
{0};

static void
saube_class_init(SaubeClass * class)
{
  GtkObjectClass *object_class;

  object_class = (GtkObjectClass *) class;

  gtk_object_class_add_signals(object_class, saube_signals, LAST_SIGNAL);
  class->saube = NULL;
}

static void
saube_init(Saube * saube)
{
}

GtkWidget *
saube_new(channel * sample)
{
  Saube *saube = NULL;
  GtkWidget *menubar, *menu, *menuitem;
  GtkWidget *vbox, *widget;

  saube = gtk_type_new(saube_get_type());

  saube->sample = sample;

  gtk_window_set_title(GTK_WINDOW(saube), "Saube");

  gtk_container_border_width(GTK_CONTAINER(saube), 1);

#if 0

  /*
     when the window is given the "delete_event" signal - this is
     * given by the window manager - usually the close option or on the
     * titlebar - we ask it to call the delete_event() function
     * as defined above. The data passed to the callback function is
     * NULL and is ignored in the callback. 
   */
  gtk_signal_connect(GTK_OBJECT(saube), "delete_event",
		     GTK_SIGNAL_FUNC(delete_event), NULL);

  /*
     here we connect the "destroy" event to a signal hanser.
     * This event occurs when we call gtk_widget_destroy() on the
     * window, or if we return "TRUE" in the "delete_event" callback. 
   */
  gtk_signal_connect(GTK_OBJECT(saube), "destroy",
		     GTK_SIGNAL_FUNC(destroy), NULL);
#endif

  vbox = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(saube), vbox);


  /*
     M E N U B A R 
   */

  menubar = gtk_menu_bar_new();
  gtk_box_pack_start(GTK_BOX(vbox), menubar, FALSE, TRUE, 0);

  /*
     FILE MENU 
   */

  menu = gtk_menu_new();

  menuitem = gtk_menu_item_new_with_label("Load...");
  gtk_menu_append(GTK_MENU(menu), menuitem);
#if 0
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
		     GTK_SIGNAL_FUNC(sample_load_cb), NULL);
#endif
  gtk_widget_show(menuitem);

  menuitem = gtk_menu_item_new_with_label("Save...");
  gtk_menu_append(GTK_MENU(menu), menuitem);
#if 0
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
		     GTK_SIGNAL_FUNC(sample_save_cb), NULL);
#endif
/*
   gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
   GTK_SIGNAL_FUNC(saube_save_sample), saube);
 */
  gtk_widget_show(menuitem);

  menuitem = gtk_menu_item_new_with_label("Close");
  gtk_menu_append(GTK_MENU(menu), menuitem);
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
		     GTK_SIGNAL_FUNC(saube_dismiss), saube);
  gtk_widget_show(menuitem);

  menuitem = gtk_menu_item_new_with_label("File");
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuitem), menu);
  gtk_menu_bar_append(GTK_MENU_BAR(menubar), menuitem);
  gtk_widget_show(menuitem);

  gtk_widget_show(menubar);

  widget = gtk_label_new("Blum");
  gtk_box_pack_start(GTK_BOX(vbox), widget, FALSE, FALSE, 1);
  gtk_widget_show(widget);
  saube->namelabel = widget;

  widget = gtk_hruler_new();
  gtk_box_pack_start(GTK_BOX(vbox), widget, FALSE, FALSE, 1);
  gtk_widget_show(widget);
  saube->hruler = widget;

  gtk_widget_show(vbox);

  gtk_widget_set_usize(GTK_WIDGET(saube), 100, 40);

  saube_refresh(saube);

  return GTK_WIDGET(saube);
}

void
saube_dismiss(GtkWidget * widget, gpointer data)
{
  gtk_widget_destroy(GTK_WIDGET(data));
}

void
saube_refresh(Saube * s)
{
  if (s->sample != NULL) {
    /*
       gtk_label_set_text(GTK_LABEL(s->namelabel), s->sample->u_label);
     */
    gtk_label_set(GTK_LABEL(s->namelabel), s->sample->u_label);
    gtk_ruler_set_range(GTK_RULER(s->hruler), 0, s->sample->parms.d.audio_sample_data.s_length, 0, s->sample->parms.d.audio_sample_data.s_length);
  } else {
    /*
       gtk_label_set_text(GTK_LABEL(s->namelabel), "No sample loaded");
     */
    gtk_label_set(GTK_LABEL(s->namelabel), "No sample loaded");
    gtk_ruler_set_range(GTK_RULER(s->hruler), 0, 1000, 0, 1000);
  }
}

#if 0
void
saube_save_sample(GtkWidget * widget, gpointer data)
{
  aube_save_sample(selected_sample);
}

#endif

#if 0
void
saube_delete_sample(GtkWidget * widget, gpointer data)
{
  aube_remove_sample(selected_sample);
}

#endif
