/*
 * Sweep, a sound wave editor.
 *
 * Copyright (C) 2000 Conrad Parker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif


#ifdef DEVEL_CODE


#include <stdio.h>
#include <string.h>
#include <glib.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include <sweep/sweep_i18n.h>
#include <sweep/sweep_undo.h>
#include <sweep/sweep_sample.h>
#include <sweep/sweep_sounddata.h>
#include <sweep/sweep_selection.h>

#include "sweep_app.h"
#include "edit.h"
#include "interface.h"

#if 0
#include "../pixmaps/pastemix.xpm"
#include "../pixmaps/pastexfade.xpm"
#endif

/*#define DEBUG*/


#if 0
static GtkWidget *
create_pixmap_button (GtkWidget * widget, gchar ** xpm_data,
		      const gchar * label_text, const gchar * tip_text,
		      GtkSignalFunc clicked)
{
  GtkWidget * hbox;
  GtkWidget * label;
  GtkWidget * pixmap;
  GtkWidget * button;
  GtkTooltips * tooltips;

  button = gtk_button_new ();

  hbox = gtk_hbox_new (FALSE, 2);
  gtk_container_add (GTK_CONTAINER(button), hbox);
  gtk_container_set_border_width (GTK_CONTAINER(button), 8);
  gtk_widget_show (hbox);

  if (xpm_data != NULL) {
    pixmap = create_widget_from_xpm (widget, xpm_data);
    gtk_box_pack_start (GTK_BOX(hbox), pixmap, FALSE, FALSE, 8);
    gtk_widget_show (pixmap);
  }

  if (label_text != NULL) {
    label = gtk_label_new (label_text);
    gtk_box_pack_start (GTK_BOX(hbox), label, FALSE, FALSE, 8);
    gtk_widget_show (label);
  }

  if (tip_text != NULL) {
    tooltips = gtk_tooltips_new ();
    gtk_tooltips_set_tip (tooltips, button, tip_text, NULL);
  }

  if (clicked != NULL) {
    gtk_signal_connect (GTK_OBJECT (button), "clicked",
			GTK_SIGNAL_FUNC(clicked), NULL);
  }

  return button;
}
#endif

static void
paste_dialog_destroy (GtkWidget * widget, gpointer data)
{
  sw_sample * sample = (sw_sample *)data;
  sample->paste_dialog = NULL;
}

static void
paste_dialog_ok_cb (GtkWidget * widget, gpointer data)
{
  GtkWidget * dialog;
  sw_sample * sample = (sw_sample *)data;

  dialog = gtk_widget_get_toplevel (widget);
  gtk_widget_hide (dialog);

  do_paste_mix (sample);

  sample_set_edit_state (sample, SWEEP_EDIT_STATE_IDLE);
}

static void
paste_dialog_cancel_cb (GtkWidget * widget, gpointer data)
{
  GtkWidget * dialog;
  sw_sample * sample = (sw_sample *)data;

  dialog = gtk_widget_get_toplevel (widget);
  gtk_widget_hide (dialog);

  sample_set_edit_state (sample, SWEEP_EDIT_STATE_IDLE);
}

void
create_paste_mix_dialog (sw_sample * sample)
{
  GtkWidget * dialog;
  GtkWidget * vbox;
  GtkWidget * hbox;
  GtkWidget * vscale;
  GtkWidget * ok_button, * button;

  GtkObject * adj;
  GtkAccelGroup * accel_group;

  if (sample->paste_dialog == NULL) {
    dialog = gtk_dialog_new ();
    gtk_window_set_wmclass(GTK_WINDOW(dialog), "paste_dialog", "Sweep");
    gtk_window_set_title(GTK_WINDOW(dialog), _("Sweep: Paste mix"));
    gtk_window_set_policy(GTK_WINDOW(dialog), FALSE, FALSE, FALSE);
    gtk_window_position(GTK_WINDOW(dialog), GTK_WIN_POS_MOUSE);
    gtk_container_border_width (GTK_CONTAINER(dialog), 8);

    accel_group = gtk_accel_group_new ();
    gtk_window_add_accel_group (GTK_WINDOW(dialog), accel_group);

    gtk_signal_connect(GTK_OBJECT(dialog), "destroy",
		       (GtkSignalFunc) paste_dialog_destroy, sample);

    gtk_accel_group_add (accel_group, GDK_w, GDK_CONTROL_MASK, GDK_NONE,
			 GTK_OBJECT(dialog), "hide");

    vbox = GTK_DIALOG(dialog)->vbox;

    hbox = gtk_hbox_new (FALSE, 8);
    gtk_box_pack_start (GTK_BOX(vbox), hbox, TRUE, TRUE, 8);
    gtk_widget_show (hbox);

    adj = gtk_adjustment_new (0.7,  /* value */
			      0.0,  /* lower */
			      1.0,  /* upper */
			      0.01, /* step */
			      0.1,  /* page incr*/
			      0.01  /* page size */
			      );

    vscale = gtk_vscale_new (GTK_ADJUSTMENT(adj));
    gtk_box_pack_start (GTK_BOX(hbox), vscale, TRUE, TRUE, 0);
    gtk_widget_show (vscale);


    adj = gtk_adjustment_new (0.7,  /* value */
			      0.0,  /* lower */
			      1.0,  /* upper */
			      0.01, /* step */
			      0.1,  /* page incr*/
			      0.01  /* page size */
			      );

    vscale = gtk_vscale_new (GTK_ADJUSTMENT(adj));
    gtk_box_pack_start (GTK_BOX(hbox), vscale, TRUE, TRUE, 0);
    gtk_widget_show (vscale);

#if 0
    hbox = gtk_hbox_new (FALSE, 8);
    gtk_box_pack_start (GTK_BOX(vbox), hbox, TRUE, TRUE, 8);
    gtk_widget_show (hbox);

    label = gtk_label_new (_("Sample:"));
    gtk_box_pack_start (GTK_BOX(hbox), label, FALSE, FALSE, 0);
    gtk_widget_show (label);

    combo = gtk_combo_new ();
    gtk_box_pack_start (GTK_BOX(hbox), combo, TRUE, TRUE, 0);
    gtk_widget_show (combo);

    gtk_entry_set_editable (GTK_ENTRY(GTK_COMBO(combo)->entry), FALSE);

    gtk_signal_connect (GTK_OBJECT(GTK_COMBO(combo)->entry), "changed",
			GTK_SIGNAL_FUNC(undo_dialog_entry_changed_cb), NULL);

    hbox = gtk_hbox_new (TRUE, 8);
    gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);
    gtk_widget_show (hbox);

    button = create_pixmap_button (undo_dialog, undo_xpm, _("Undo"), _("Undo"),
				   ud_undo_cb);
    gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);
    gtk_widget_show (button);
    gtk_widget_add_accelerator (button, "clicked", accel_group,
				GDK_z, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
    undo_button = button;

    button = create_pixmap_button (undo_dialog, redo_xpm, _("Redo"), _("Redo"),
				   ud_redo_cb);
    gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);
    gtk_widget_show (button);
    gtk_widget_add_accelerator (button, "clicked", accel_group,
				GDK_r, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
    redo_button = button;

    scrolled = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW(scrolled),
				    GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
    gtk_box_pack_start (GTK_BOX(GTK_DIALOG(undo_dialog)->vbox), scrolled,
			FALSE, FALSE, 0);
    gtk_widget_set_usize (scrolled, 360, 240);
    gtk_widget_show (scrolled);

    undo_clist = gtk_clist_new (1);
    gtk_clist_set_selection_mode (GTK_CLIST(undo_clist), GTK_SELECTION_BROWSE);
    gtk_container_add (GTK_CONTAINER(scrolled), undo_clist);
    gtk_widget_show (undo_clist);

    button = gtk_button_new_with_label (_("Revert to selected state"));
    GTK_WIDGET_SET_FLAGS (GTK_WIDGET (button), GTK_CAN_DEFAULT);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG(undo_dialog)->action_area),
			button, TRUE, TRUE, 0);
    gtk_widget_show (button);
    gtk_signal_connect (GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC (undo_dialog_revert_cb),
			NULL);
    revert_button = button;
#endif

    /* OK */

    ok_button = gtk_button_new_with_label (_("OK"));
    GTK_WIDGET_SET_FLAGS (GTK_WIDGET (ok_button), GTK_CAN_DEFAULT);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialog)->action_area),
			ok_button, TRUE, TRUE, 0);
    gtk_widget_show (ok_button);
    gtk_signal_connect (GTK_OBJECT(ok_button), "clicked",
			GTK_SIGNAL_FUNC (paste_dialog_ok_cb),
			sample);

    /* Cancel */

    button = gtk_button_new_with_label (_("Cancel"));
    GTK_WIDGET_SET_FLAGS (GTK_WIDGET (button), GTK_CAN_DEFAULT);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialog)->action_area),
			button, FALSE, FALSE, 0);
    gtk_widget_show (button);
    gtk_signal_connect (GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC (paste_dialog_cancel_cb),
			sample);

    gtk_widget_grab_default (ok_button);

    sample->paste_dialog = dialog;

  } else {
    dialog = sample->paste_dialog;
  }

  sample_set_edit_state (sample, SWEEP_EDIT_STATE_BUSY);
  sample_set_edit_mode (sample, SWEEP_EDIT_MODE_FILTER);
  sample_set_progress_percent (sample, 0);
  
  if (!GTK_WIDGET_VISIBLE(dialog)) {
    gtk_widget_show (dialog);
  } else {
    gdk_window_raise (dialog->window);
  }
}


#endif /* DEVEL_CODE */
